'use strict';

/**
 * Only accept codes that are numbers, otherwise discard them
 * @param {*} code
 * @returns {number}
 * @private
 */

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function parseCode(code) {
	var number = Number(code);
	if (isNaN(number)) return null;
	return number;
}

/**
 * Fetch the code from the value
 * @param {Object|Error} value
 * @returns {boolean}
 * @private
 */
function fetchCode(value) {
	return value && (parseCode(value.exitCode) || parseCode(value.errno) || parseCode(value.code));
}

/**
 * Prevent [a weird error on node version 4](https://github.com/bevry/errlop/issues/1) and below.
 * @param {*} value
 * @returns {boolean}
 * @private
 */
function isValid(value) {
	/* eslint no-use-before-define:0 */
	return value instanceof Error || Errlop.isErrlop(value);
}

/**
 * Create an instance of an error, using a message, as well as an optional parent.
 * If the parent is provided, then the `fullStack` property will include its stack too
 * @class Errlop
 * @constructor
 * @param {Errlop|Error|Object|string} input
 * @param {Errlop|Error} [parent]
 * @public
 */

var Errlop = function (_Error) {
	_inherits(Errlop, _Error);

	function Errlop(input, parent) {
		_classCallCheck(this, Errlop);

		if (!input) throw new Error('Attempted to create an Errlop without a input');

		// Instantiate with the above

		/**
   * Duck typing as node 4 and intanceof does not work for error extensions
   * @type {Errlop}
   * @public
   */
		var _this = _possibleConstructorReturn(this, (Errlop.__proto__ || Object.getPrototypeOf(Errlop)).call(this, input.message || input));

		_this.klass = Errlop;

		/**
   * The parent error if it was provided.
   * If a parent was provided, then use that, otherwise use the input's parent, if it exists.
   * @type {Error?}
   * @public
   */
		_this.parent = parent || input.parent;

		/**
   * An array of all the ancestors. From parent, to grand parent, and so on.
   * @type {Array<Error>}
   * @public
   */
		_this.ancestors = [];
		var ancestor = _this.parent;
		while (ancestor) {
			_this.ancestors.push(ancestor);
			ancestor = ancestor.parent;
		}

		// this code must support node 0.8, as well as prevent a weird bug in node v4: https://travis-ci.org/bevry/editions/jobs/408828147
		var exitCode = fetchCode(input);
		if (exitCode == null) exitCode = fetchCode(_this);
		for (var index = 0; index < _this.ancestors.length && exitCode == null; ++index) {
			var error = _this.ancestors[index];
			if (isValid(error)) exitCode = fetchCode(error);
		}

		/**
   * A numeric code to use for the exit status if desired by the consumer.
   * It cycles through [input, this, ...ancestors] until it finds the first [exitCode, errno, code] that is valid.
   * @type {Number?}
   * @public
   */
		_this.exitCode = exitCode;

		/**
   * The stack for our instance alone, without any parents.
   * If the input contained a stack, then use that.
   * @type {string}
   * @public
   */
		_this.orphanStack = (input.stack || _this.stack).toString();

		/**
   * The stack which now contains the accumalated stacks of its ancestors.
   * This is used instead of an alias like `fullStack` or the like, to ensure existing code that uses `err.stack` doesn't need to be changed to remain functional.
   * @type {string}
   * @public
   */
		_this.stack = [_this.orphanStack].concat(_toConsumableArray(_this.ancestors)).reduce(function (accumulator, error) {
			return accumulator + '\n\u21B3 ' + (error.orphanStack || error.stack || error);
		});
		return _this;
	}

	/**
  * Syntatic sugar for Errlop class creation.
  * Enables `Errlop.create(...args)` to achieve `new Errlop(...args)`
  * @param {...*} args
  * @returns {Errlop}
  * @static
  * @public
  */


	_createClass(Errlop, null, [{
		key: 'create',
		value: function create() {
			for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
				args[_key] = arguments[_key];
			}

			return new (Function.prototype.bind.apply(this, [null].concat(args)))();
		}

		/**
   * Check whether or not the value is an Errlop instance
   * @param {*} value
   * @returns {boolean}
   * @static
   * @public
   */

	}, {
		key: 'isErrlop',
		value: function isErrlop(value) {
			return value && (value instanceof this || value.klass === this);
		}

		/**
   * Ensure that the value is an Errlop instance
   * @param {*} value
   * @returns {Errlop}
   * @static
   * @public
   */

	}, {
		key: 'ensure',
		value: function ensure(value) {
			return this.isErrlop(value) ? value : this.create(value);
		}
	}]);

	return Errlop;
}(Error);

module.exports = Errlop;